/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.standalone.Locator;
import hsr.pma.standalone.model.ApplicationScreen;
import hsr.pma.standalone.model.ControlScreen;
import hsr.pma.standalone.model.EndScreen;
import hsr.pma.standalone.model.LicenseScreen;
import hsr.pma.standalone.model.ResultScreen;
import hsr.pma.standalone.model.Screen;
import hsr.pma.standalone.model.StartScreen;
import hsr.pma.standalone.pd.Controller;
import hsr.pma.standalone.pd.ControllerListener;
import hsr.pma.standalone.view.ApplicationPanel;
import hsr.pma.standalone.view.ControlPanel;
import hsr.pma.standalone.view.EndPanel;
import hsr.pma.standalone.view.LicensePanel;
import hsr.pma.standalone.view.ResultPanel;
import hsr.pma.standalone.view.StartPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class StandaloneFrame
extends JFrame
implements ControllerListener {
    private static final long serialVersionUID = 1L;
    private static boolean DEBUG = false;
    private static final Dimension MINIMUM_WINDOW_SIZE = new Dimension(320, 200);
    public final Controller controller;
    public final JPanel content;
    private final ApplicationPanel applicationPanel;

    public StandaloneFrame(Controller controller) {
        this.controller = controller;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            controller.loadModel();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            System.exit(-1);
        }
        try {
            controller.loadApplication();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            System.exit(-1);
        }
        this.setTitle(controller.getTitle());
        this.setMinimumSize(MINIMUM_WINDOW_SIZE);
        this.setResizable(controller.getModel().getWindow().isResizable());
        Locator.provide(this);
        String logoname = controller.getModel().getLogo().getImage();
        BufferedImage logo = Locator.getImageProvider().getImage(logoname);
        this.setIconImage(logo);
        this.content = (JPanel)this.getContentPane();
        this.content.setLayout(new BorderLayout());
        this.content.setPreferredSize(controller.getModel().getWindow().getSize());
        this.applicationPanel = new ApplicationPanel(controller.getModel().getContentScreen());
        controller.setApplicationPanel(this.applicationPanel.getContentPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.pack();
        this.center();
        controller.addListener(this);
        controller.showStart();
        this.setVisible(true);
    }

    private void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
    }

    @Override
    public void showScreen(Screen screen) {
        JPanel panel = null;
        this.getGlassPane().setVisible(false);
        if (DEBUG) {
            panel = this.getDebugPanel();
        } else if (screen instanceof StartScreen) {
            panel = new StartPanel((StartScreen)screen);
        } else if (screen instanceof LicenseScreen) {
            panel = new LicensePanel((LicenseScreen)screen);
        } else if (screen instanceof ControlScreen) {
            panel = new ControlPanel((ControlScreen)screen);
        } else if (screen instanceof ApplicationScreen) {
            panel = this.applicationPanel;
            this.getGlassPane().setVisible(true);
        } else if (screen instanceof ResultScreen) {
            panel = new ResultPanel((ResultScreen)screen);
            ((ResultPanel)panel).runAnimation();
        } else if (screen instanceof EndScreen) {
            panel = new EndPanel((EndScreen)screen);
        }
        this.content.removeAll();
        this.content.add((Component)panel, "Center");
        this.content.validate();
    }

    private JPanel getDebugPanel() {
        ResultScreen screen = this.controller.getModel().getResultScreen();
        ResultPanel panel = new ResultPanel(screen);
        panel.runAnimation();
        return panel;
    }
}

